#ifndef LINUX_COMPILE
#include "stdafx.h"
#endif

#include "edge.h"
#include "point.h"
//#include "graph.h"
#include "globals.h"
#include <math.h>

#include <iostream>
#include <new>
using namespace std;

edge::edge() {
	next = NULL;
	prev = NULL;
	start = NULL;
	stop = NULL;
	max_x = 0;
	max_y = 0;
	min_x = 0;
	min_y = 0;
	weight = INF;
	owner = NULL;
}

extern double intersect_x[512];
extern double intersect_y[512];
extern int intersect_count;

void edge::delete_all() {
	if(next) {
		next->delete_all();
		//delete next;
	}
	delete this;
}

int edge::intersects(edge *other) {
	//quick check first
	if(max_y < other->get_min_y()) return 0;
	if(min_y > other->get_max_y()) return 0;
	if(max_x < other->get_min_x()) return 0;
	if(min_x > other->get_max_x()) return 0;
	/*
	//quick check passed, do full check
	double denominator;
	denominator = (other->get_stop_y()-other->get_start_y())*(stop->x-start->x) - (other->get_stop_x()-other->get_start_x())*(stop->y-start->y);
	if(denominator == 0) return 0; //lines are parallel
	double ua;
	ua = (other->get_stop_x()-other->get_start_x())*(start->y-other->get_start_y()) - (other->get_stop_y()-other->get_start_y())*(start->x-other->get_start_x());
	ua = ua / denominator;
	if(ua > 1) return 0;
	if(ua < 0) return 0;
	double ub;
	ub = (stop->x-start->x)*(start->y-other->get_start_y()) - (stop->y-start->y)*(start->x-other->get_start_x());
	ub = ub / denominator;
	if(ua > 1) return 0;
	if(ua < 0) return 0;
	//intersection at:
	//x=start->x+ua*(stop->x-start->x);
	//y=start->y+ua*(stop->y-start->y);
	*/
	
	//m1 = (y11-y12)/(x11-x12);
	//m2 = (y21-y22)/(x21-x22);
	double x11 = start->x;
	double x12 = stop->x;
	double y11 = start->y;
	double y12 = stop->y;
	double x21 = other->get_start_x();
	double x22 = other->get_stop_x();
	double y21 = other->get_start_y();
	double y22 = other->get_stop_y();
	double den1 = x11-x12;
	double den2 = x21-x22;
	double m1, m2;
	if(den1 == 0) m1 = INF;
	else m1 = (y11-y12)/(x11-x12);
	if(den2 == 0) m2 = INF;
	else m2 = (y21-y22)/(x21-x22);
	//(-m2*x21+m1*x11-y11+y21)/(-m2+m1)
	double m1_m2 = m1 - m2;
	if(m1_m2 == 0) return 0; //lines are parallel
	double x = (m1*x11-m2*x21-y11+y21)/m1_m2;
	//check if x is in range
	if(x-max_x > DELTA) return 0;
	if(min_x-x > DELTA) return 0;
	if(x-other->get_max_x() > DELTA) return 0;
	if(other->get_min_x()-x > DELTA) return 0;
	double y = m1*(x-x11)+y11;
	if(y-max_y > DELTA) return 0;
	if(min_y-y > DELTA) return 0;
	if(y-other->get_max_y() > DELTA) return 0;
	if(other->get_min_y()-y > DELTA) return 0;
	
	return 1;
}


point *edge::intersect_point(edge *other) {
	//int r = rand();
	
	//cout << r << endl;
	//cout << start->x << "," << start->y << " " << stop->x << "," << stop->y << " " << endl;
	//cout << other->get_start_x() << "," << other->get_start_y() << " " << other->get_stop_x() << "," << other->get_stop_y() << endl;
	//quick check first
	if(max_y < other->get_min_y()) return NULL;
	if(min_y > other->get_max_y()) return NULL;
	if(max_x < other->get_min_x()) return NULL;
	if(min_x > other->get_max_x()) return NULL;
	//check for shared endpoints
	if(end_point(other->get_start())) return NULL;
	if(end_point(other->get_stop())) return NULL;
	//cout << r << endl;

	double x11 = start->x;
	double x12 = stop->x;
	double y11 = start->y;
	double y12 = stop->y;
	double x21 = other->get_start_x();
	double x22 = other->get_stop_x();
	double y21 = other->get_start_y();
	double y22 = other->get_stop_y();
	double den1 = x11-x12;
	double den2 = x21-x22;
	double m1, m2, x;
	m1 = 0;
	m2 = 0;
	if(den1 == 0) {
		//vertical edge1
		if(den2 == 0) return NULL; //both vertical
		x = x11;
		m2 = (y21-y22)/den2;
	}
	else {
		m1 = (y11-y12)/den1;
		if(den2 == 0) {
			//vertical edge2
			x = x21;
		}
		else {
			m2 = (y21-y22)/den2;
			double m1_m2 = m1 - m2;
			if(m1_m2 == 0) return NULL; //lines are parallel
			//cout << r << endl;
			x = (m1*x11-m2*x21-y11+y21)/m1_m2;
		}
	}
		//cout << "x:" << x << endl;
	//check if x is in range
	if(x-max_x > DELTA) return NULL;
	//cout << r << endl;
	if(min_x-x > DELTA) return NULL;
	//cout << r << endl;
	if(x-other->get_max_x() > DELTA) return NULL;
	//cout << r << endl;
	if(other->get_min_x()-x > DELTA) return NULL;
	//cout << r << endl;
	
	//now calc y
	double y;
	if(den1) y = m1*(x-x11)+y11;
	else y = m2*(x-x21)+y21;
	if(y-max_y > DELTA) return NULL;
	//cout << r << endl;
	if(min_y-y > DELTA) return NULL;
	//cout << r << endl;
	if(y-other->get_max_y() > DELTA) return NULL;
	//cout << r << endl;
	if(other->get_min_y()-y > DELTA) return NULL;
	//cout << r << endl;
	
	point *intersect;
	intersect = new (std::nothrow) point;
	if(!intersect) {
		cout << "Error, out of memory!\n";
		exit(-1);
	}
	intersect->x = x;
	intersect->y = y;
	
	return intersect;
}

edge::~edge() {
}

//returns the intersection of the edge and the line passed
//returns null if does not intersect
//passed slope of line, x-point on line, y-point on line
point *edge::intersect_line(double m, double x, double y) {
	//(m*x*x1-m*x*x2-y*x1+y*x2+y2*x1-y1*x2)/(m*x1-m*x2-y1+y2)
	
	//t=m*x1-m*x2=m*(x1-x2)
	//-y*x1+y2*x1=x1*(y2-y)
	//y*x2-y1*x2=x2*(y-y1)
	//d=t-y1+y2
	//(x*t +x1*(y2-y) +x2*(y-y1))/d
	/*
	double t = m*(start->x-stop->x);
	double d = t - start->y + stop->y;
	if(d == 0) return NULL; //parallel no intersection
	double xint = (x*t +start->x*(stop->y-y) +stop->x*(y-start->y))/d;
	//if((start->x-xint * stop->x-xint) > 0) return NULL; //outside of x coordinates of segment
	double yint = m*(xint-x)+y;
	*/
	
	//double x1 = start->x;
	//double x2 = stop->x;
	//double y1 = start->y;
	//double y2 = stop->y;
	//double xint = (m*x*x1-m*x*x2-y*x1+y*x2+y2*x1-y1*x2)/(m*x1-m*x2-y1+y2);
	
	//cout << "Start: " << start->x << "," << start->y << " " << stop->x << "," << stop->y << endl;
	
	double t = m*(start->x-stop->x);
	double d = t - start->y + stop->y;
	//cout << "1\n";
	if(d == 0) return NULL; //parallel no intersection
	double xint = (x*t +start->x*(stop->y-y) +stop->x*(y-start->y))/d;
	//cout << "2\n";
	if(xint-DELTA > max_x || xint+DELTA < min_x) return NULL; //no intersection
	
	double yint = m*(xint-x)+y;
	//cout << "3\n";
	//cout << "int: " << xint << "," << yint << endl;
	//cout << "min_max: " << min_y << " " << max_y << endl;
	if(yint-DELTA > max_y || yint+DELTA < min_y) return NULL;
	
	point *intersect;
	intersect = new (std::nothrow) point;
	if(!intersect) {
		cout << "Error, out of memory!\n";
		exit(-1);
	}
	intersect->x = xint;
	intersect->y = yint;
	//cout << "4\n";
	return intersect;
}

void edge::set_edge(double startx, double starty, double stopx, double stopy) {
	if(startx > stopx) {
		max_x = startx;
		min_x = stopx;
	} else {
		max_x = stopx;
		min_x = startx;
	}
	
	if(starty > stopy) {
		max_y = starty;
		min_y = stopy;
	} else {
		max_y = stopy;
		min_y = starty;
	}
	
	if(start==NULL) {
		start = new (std::nothrow) point;
		if(!start) {
			cout << "Error, out of memory." << endl;
			exit(-1);
		}
	}
	
	if(stop==NULL) {
		stop = new (std::nothrow) point;
		if(!stop) {
			cout << "Error, out of memory." << endl;
			exit(-1);
		}
	}
	
	start->x = startx;
	start->y = starty;
	stop->x = stopx;
	stop->y = stopy;
}
	
int edge::end_point(point *check_point) {
	if(start->same(check_point)) return 1;
	if(stop->same(check_point)) return 1;
	return 0;
}
		
edge::edge(point *nstart, point *nstop) {
	//start = nstart;
	//stop = nstop;
	next = NULL;
	prev = NULL;
	
	weight = INF;
	if(nstart->x > nstop->x) {
		start = nstop;
		stop = start;
		max_x = nstart->x;
		min_x = nstop->y;
	} else {
		start = nstart;
		stop = nstop;
		max_x = nstop->x;
		min_x = nstart->x;
	}
	
	if(start->y > stop->y) {
		max_y = start->y;
		min_y = stop->y;
	} else {
		max_y = stop->y;
		min_y = start->y;
	}
	owner = NULL;
}

point *edge::get_start() {
	return start;
}

point *edge::get_stop() {
	return stop;
}

void edge::set_start(point *newstart) {
	start = newstart;
	if(start->x > stop->x) {
		min_x = stop->x;
		max_x = start->x;
	} else {
		min_x = start->x;
		max_x = stop->x;
	}
	if(start->y > stop->y) {
		min_y = stop->y;
		max_y = start->y;
	} else {
		min_y = start->y;
		max_y = stop->y;
	}
}

void edge::set_stop(point *newstop) {
	stop = newstop;
	if(start->x > stop->x) {
		min_x = stop->x;
		max_x = start->x;
	} else {
		min_x = start->x;
		max_x = stop->x;
	}
	if(start->y > stop->y) {
		min_y = stop->y;
		max_y = start->y;
	} else {
		min_y = start->y;
		max_y = stop->y;
	}
}

int edge::in_between(double a,double b,double c) {
	if (a<=b && a>=c) return 1;
	if (a>=b && a<=c) return 1;
	return 0;
}

void edge::update_weight(point *p) {
	/*
	double xp, yp, m, d1, d2;
	if(start->x==stop->x) {
		xp=start->x;
		yp = p->y;
	}
	else if(start->y==stop->y) {
		xp=p->x;
		yp = start->y;
	} else {
		m = (start->y-stop->y)/(start->x-stop->x);
		xp = (p->y-stop->y+m*stop->x+p->x/m)/(m+1/m);
		yp = m*(xp-stop->x)+stop->y;
	}
	if(!in_between(xp,stop->x,start->x) || !in_between(yp,stop->y,start->y)) {
		d1 = sqrt((stop->x-p->x)*(stop->x-p->x)+(stop->y-p->y)*(stop->y-p->y));
		d2 = sqrt((start->x-p->x)*(start->x-p->x)+(start->y-p->y)*(start->y-p->y));
		if (d1<d2) if(d1 < weight) weight = d1;
		if(d2 < weight) weight = d2;
	}
	d1 = sqrt((xp-p->x)*(xp-p->x)+(yp-p->y)*(yp-p->y));
	if(d1 < weight) weight = d1;
	*/
	double x, y, x1, y1, x2, y2;
	x = p->x;
	y = p->y;
	x1 = start->x;
	x2 = stop->x;
	y1 = start->y;
	y2 = stop->y;
	//double map::get_distance(double x, double y, double x1, double y1, double x2, double y2) {
		double d1,d2, yp,xp,m;

		if (x2==x1) { // Vertical line
			xp=x1;
			yp=y;
		}
		else if (y2==y1) { // horizontal line
			xp=x;
			yp=y1;
		}
		else {
			m  = (y2-y1)/(x2-x1);
			xp = (y-y1+m*x1+x/m)/(m+1/m);
			yp = m*(xp-x1)+y1;
		}
	
		if (!in_between(xp,x1,x2) || !in_between(yp,y1,y2)) {
			d1=sqrt((x1-x)*(x1-x)+(y1-y)*(y1-y));
			d2=sqrt((x2-x)*(x2-x)+(y2-y)*(y2-y));
			//if (d1<d2) return d1;
			//return d2;
			if(d1 < weight) weight = d1;
			if(d2 < weight) weight = d2;
			return;
		}
		//return sqrt((xp-x)*(xp-x)+(yp-y)*(yp-y));
		double d3 = sqrt((xp-x)*(xp-x)+(yp-y)*(yp-y));
		if(d3 < weight) weight = d3;
	//}
	
}

edge::edge(double startx, double starty, double stopx, double stopy) {
	next = NULL;
	prev = NULL;
	
	weight = INF;
	
	start = new (std::nothrow) point;
	if(!start) {
		cout << "Error, out of memory." << endl;
		exit(-1);
	}
	stop = new (std::nothrow) point;
	if(!stop) {
		cout << "Error, out of memory." << endl;
		exit(-1);
	}
	
	if(startx > stopx) {
		start->x = stopx;
		start->y = stopy;
		stop->x = startx;
		stop->y = starty;
		max_x = startx;
		min_x = stopx;
	} else {
		start->x = startx;
		start->y = starty;
		stop->x = stopx;
		stop->y = stopy;
		max_x = stopx;
		min_x = startx;
	}
	
	if(starty > stopy) {
		max_y = starty;
		min_y = stopy;
	} else {
		max_y = stopy;
		min_y = starty;
	}
	
	owner = NULL;
}

double edge::get_start_x() {
	return start->x;
}

double edge::get_stop_x() {
	return stop->x;
}

double edge::get_start_y() {
	return start->y;
}

double edge::get_stop_y() {
	return stop->y;
}

double edge::get_max_x() {
	return max_x;
}

double edge::get_max_y() {
	return max_y;
}

double edge::get_min_x() {
	return min_x;
}

double edge::get_min_y() {
	return min_y;
}
