//Important note: by convention startx<=stopx
//to aid in line sweep, and to avoid updating
//max and min all the time
//when creating or setting an edge be sure to
//follow this convention

#ifndef EDGE_H
#define EDGE_H

#include "point.h"
//#include "graph.h"

enum edge_type{
	FOV,
	VORONOI,
	PATH_FOV,
	PATH_VORONOI,
	EXTRA,
	START
};

class edge {
	public:
		edge();
		~edge();
		void set_edge(double, double, double, double);
		
		//creates an edge at x,y,x,y
		edge(double, double, double, double);
		edge(point *, point *);
		
		//returns the corresponding value
		double get_max_x();
		double get_max_y();
		double get_min_x();
		double get_min_y();
		
		//returns true if the edge intersects the current
		int intersects(edge *);
		point *intersect_point(edge *);
		
		//returns true if point is the same as an endpoint
		int end_point(point *);
		
		//returns the intersection of the edge and the line passed
		//returns null if does not intersect
		//passed slope of line, x-point on line, y-point on line
		point *intersect_line(double, double, double);
		
		edge *prev;
		edge *next;
		
		double get_start_x();
		double get_stop_x();
		double get_start_y();
		double get_stop_y();
		point *get_stop();
		point *get_start();
		void set_stop(point *);
		void set_start(point *);
		
		void update_weight(point *);
		
		void delete_all();
		
		edge_type type;
		
		double weight;
		
		void *owner;
		
	private:
		int in_between(double,double,double);
		
		double max_x;
		double min_x;
		double max_y;
		double min_y;
		point *start;
		point *stop;
};

#endif
