// Graph Implementation ////////////////////////////////////////////////////////
// By Giacomino Veltri
// Last Updated: April 19, 2000
//
// Modified by Seapahn Meguerdichian
// Removed templates
// Optimized binary search 
// May 10, 2000
//
//#include "Demo.h"

#ifndef LINUX_COMPILE
#include "stdafx.h"
#endif

#include <iostream>
#include <new>
using namespace std;
#include "graph.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

Vertex::Vertex() {
	if(Adjacent == NULL) {
		cout << "Error, Out of memory." << endl;
		exit(-1);
	}
	Previous= -1;
	adj_count= 0;
} 

void Vertex::initialize() {
	Previous= -1;
	adj_count= 0;
}

void Vertex::AddEdge(double W, int d) {
	if (adj_count==MAX_EDGES) {
		//AfxMessageBox("Error, Vertex Edge count exceeded.");
		cout << "Error, Vertex Edge count exceeded." << endl;
		exit(-1);
	}
	else {
		Adjacent[adj_count  ].Cost=W;
		Adjacent[adj_count++].Dest=d;
	}
}

void Vertex::Init(int name) {
	Name     = name;
	Previous = -1;
	adj_count= 0;
}

Vertex::~Vertex() {
}

////////////////////////////////////////

Graph::Graph() {
	V=NULL;
	P=NULL;
	v_count=0;
	p_count=0;
}


Graph::~Graph() { 
	if (V) delete [] V;
	if (P) delete [] P;
}

void Graph::initialize() {
	//if (V==NULL) V=new (std::nothrow) Vertex[MAX_VERTICES];
	if(V) {
		delete [] V;
		V = NULL;
	}
#ifdef LINUX_COMPILE
	V = new (std::nothrow) Vertex[MAX_VERTICES];
#else
	V = new Vertex[MAX_VERTICES];
#endif
	if (V==NULL) {
		//AfxMessageBox("Error, Not Enough Memory");
		cout << "Error, Not Enough Memory" << endl;
		exit(-1);
	}
	for (int i=0; i<MAX_VERTICES; i++) V[i].initialize();    // this is redundant but makes me feel better!
#ifdef LINUX_COMPILE
	if (P==NULL) P=new (std::nothrow) int[MAX_PATHLEN];
#else
	if (P==NULL) P=new int[MAX_PATHLEN];
#endif
	if (P==NULL) {
		cout << "Error, Not Enough Memory" << endl;
		exit(-1);
	}
	v_count = 0;
	p_count = 0;
}

void Graph::reset() {
	ClearData();
	v_count=0;
	p_count=0;
}

void Graph::ClearData() { // Sets All Vertices to Not Visited
	for (int i=0; i<v_count; ++i) V[i].Previous = -1;
}


int Graph::AddEdge(int S,int E,double W) { 
	int i=FindVertex(S);
	if (i==v_count)	{
		if(v_count+1 >= MAX_VERTICES) {
			cout << "Error, Max Vertices exceeded." << endl;
			exit(-1);
		}
		V[v_count++].Init(S);
	}
	V[i].AddEdge(W,E);

	i=FindVertex(E);
	if (i==v_count)	{
		if(v_count+1 >= MAX_VERTICES) {
			cout << "Error, Max Vertices exceeded." << endl;
			exit(-1);
		}
		V[v_count++].Init(E);
	}
	V[i].AddEdge(W,S);

	return 1;
}

int Graph::FindVertex(int name) {
	int i;
	for (i=0; i<v_count && V[i].Name!=name; i++);
	return i;
}


int  Graph::BreadthFirst(int S, int E, double Bound,int method) {
	//int VQ[MAX_VERTICES];			// Queue to Check Next Vertices
#ifdef LINUX_COMPILE
	int *VQ = new (std::nothrow) int[MAX_VERTICES];
#else
	int *VQ = new int[MAX_VERTICES];
#endif
	if(!VQ) {
		cout << "Error, Out Of Memory" << endl;
		exit(-1);
	}
	int i,v, Success=0;
	int next = 0;

	ClearData();					// Clear All Visited Node Data
	
	// Check to see if start and end are valid vertices
	if (       FindVertex(E) ==v_count)	return 0; 
	if ((VQ[0]=FindVertex(S))==v_count) return 0; 

	int VQ_start=0;					// Enqueued the start node
	int VQ_end  =1;

	V[VQ[VQ_start]].Previous=-2;		

	while (VQ_start<VQ_end && !Success) {
		if(VQ_start+1 >= MAX_VERTICES) {
			cout << "Error, Max Vertices exceeded" << endl;
			exit(-1);
		}
		v=VQ[VQ_start++];					// dequeue a vertex
		for (i=0; i<V[v].adj_count && Success==0; i++) {
			if ((V[v].Adjacent[i].Cost>=Bound && method==LOWER_BOUND_SEARCH) || 
							(V[v].Adjacent[i].Cost<=Bound && method==UPPER_BOUND_SEARCH)) {
				next=FindVertex(V[v].Adjacent[i].Dest);
				if (V[next].Previous==-1) {
					V[next].Previous=v;
					if(VQ_end+1 >= MAX_VERTICES) {
						cout << "Error, Max Vertices exceeded" << endl;
						exit(-1);
					}
					VQ[VQ_end++]=next;        // Enqueue vertex
					if (V[next].Name==E)
						Success = 1;
				}
							}
		}
	}

	if (Success) {
		P[0]=V[next].Name;
		for (p_count=1; V[next].Previous>=0; p_count++) {
			next=V[next].Previous;
			if(p_count >= MAX_PATHLEN) {
				cout << "Error, Max Pathlen exceeded." << endl;
				exit(-1);
			}
			P[p_count]=V[next].Name;
		}
	}
	return Success;
} 



double Graph::MaxPath(int S, int E, double L, double U) {
	double M, nL;  // MidPoint of the Weights
	int exists=1;
	
	if (L>U || !BreadthFirst(S,E,L,LOWER_BOUND_SEARCH)) return -1;

	nL=(U+L)/2;
	for (M=(U-nL)/2; M>0.5; M=M/2) {
		exists=BreadthFirst(S,E,nL,LOWER_BOUND_SEARCH);
		if(exists)
			nL=nL+M;
		else
			nL=nL-M;
	}
	while (!exists)	exists=BreadthFirst(S,E,--nL,LOWER_BOUND_SEARCH);
	return (MarkCritical(LOWER_BOUND_SEARCH));
}


double Graph::MinPath(int S, int E, double L, double U) {
	double M, nU;  // MidPoint of the Weights
	int exists=1;
	
	if (L>U || !BreadthFirst(S,E,U,UPPER_BOUND_SEARCH)) return -1;

	nU=(U+L)/2;
	for (M=(nU-L)/2; M>0.5; M=M/2) {
		exists=BreadthFirst(S,E,nU,UPPER_BOUND_SEARCH);
		if(exists)
			nU=nU-M;
		else
			nU=nU+M;
	}
	while (!exists)	exists=BreadthFirst(S,E,++nU,UPPER_BOUND_SEARCH);
	return (MarkCritical(UPPER_BOUND_SEARCH));
}


double Graph::MarkCritical(int method) {
	double weight,extreme;
	int i,j,v;

	if (method==UPPER_BOUND_SEARCH) extreme=-10000; else extreme=10000;
	for (i=p_count-2; i>1; --i) {
		v=FindVertex(P[i]);
		for (j=0; j<V[v].adj_count && V[v].Adjacent[j].Dest!=P[i-1]; j++);
		weight=V[v].Adjacent[j].Cost;
		if ((method==UPPER_BOUND_SEARCH && weight>=extreme) ||
					 (method==LOWER_BOUND_SEARCH && weight<=extreme)) {
			extreme=weight;
			critical=i;
					 }
	}
	return extreme;
}
