// Graph Header File ///////////////////////////////////////////////////////////
//
// Seapahn Meguerdichian
// May 10, 2000
// Combined linked list, queue, and stack into one class
// Then removed list completely due to Template problems
// Optimized for fast performance
// Corrected Algorithmic errors
//
// Based on initial code by
// By Giacomino Veltri
// Last Updated: April 19, 2000
//


#if !defined(AFX_GRAPH_H__2F446042_26EA_11D4_8603_0080C8C1A536__INCLUDED_)
#define AFX_GRAPH_H__2F446042_26EA_11D4_8603_0080C8C1A536__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define MAX_EDGES    2000
#define MAX_PATHLEN  50000
//#define MAX_VERTICES 50000

// Constants for breadth first search
#define LOWER_BOUND_SEARCH 0
#define UPPER_BOUND_SEARCH 1

struct GVEdge {		// Edge
    int    Dest;	// Second Vertex in the Edge
    double Cost;	// Weight of the Edge
};

class Vertex {
public:
	Vertex();
	~Vertex();
	void initialize();
	void Init(int name);
	void AddEdge(double W, int d);

	int Name;							// Vertex Name
	int Previous;						// -1 if not visited, else previous Vertex name in path
	int adj_count;
    GVEdge Adjacent[MAX_EDGES];			// Adjacent Vertices
};


class Graph {
public:
	int MAX_VERTICES;

    Graph();
    ~Graph();
	void reset();
	void initialize();
    void ClearData();
	int  FindVertex(int name);
	int  AddEdge(int S,int E, double W);
	int  BreadthFirst(int S,int E, double Bount, int method);
	double MaxPath(int S, int E, double L, double U);
	double MinPath(int S, int E, double L, double U);
	double MarkCritical(int method);
	
    Vertex *V;		
    int *P;
	int p_count;
	int v_count;
	int critical;
}; 


#endif // !defined(AFX_GRAPH_H__2F446042_26EA_11D4_8603_0080C8C1A536__INCLUDED_)
