#ifndef MAP_H
#define MAP_H

#include "edge.h"
#include "node.h"
#include "point.h"
#include "graph.h"

class map {
	public:
		//constructor
		map();
		
		void set_width(double);
		void set_height(double);
		
		double get_width();
		double get_height();
	
#ifdef GUI
		void draw();
#endif
		
		//adds a node to the end of the list
		//x,y,start angle, sweep angle, range
		void add_node(double, double, double, double, double);
		
		//adds an edge to the end of the list
		//at x,y,x,y
		void add_edge(double, double, double, double, edge_type);
		
		//sorts the edge list
		void bad_sort_max_x();
		void bad_sort_max_y();
		void sort_edges_max_x();
		void sort_edges_min_x();
		void sort_edges_max_y();
		void sort_edges_min_y();
		//void sort_edges();
		
		//sorts the nodes based on min_x
		void sort_nodes();
		
		//verfies the list is sorted
		int check_sort_max_x();
		int check_sort_min_x();
		
		//verifies the list is stable
		//must run sort_max_y then sort_max_x
		int check_stable();

		void print_map(int);
		
		//adds semi-voronoi edges in overlapped fovs
		//using line sweep algorithm
		void add_overlap_edges();
		
		//breaks all intersecting edges
		//using line sweep algorithm
		void intersect_edges();
		
		void update_weights();
		
		void add_border();
		
		double find_maximal_breach();
		
		void remove_outside_edges();
		
		edge *remove_edge(edge *);
		
		void move(double);
		
		void refresh_structures();
		
		//void construct_graph();
		
		int fov_on, nodes_on, voronoi_on, path_on, weight_color_on, rotation_on, movement_on;
		double node_size, voronoi_size, fov_size, path_size;
		
		int only_fov;
		double grid;
		
		double max_range;
		
		basic_node *simple_map;
	private:
		double width, height;
		
		void print_map(edge *, int);
		void sort_edges(int);
		edge* pop_edge(edge *);
		//edge* push_edge(edge *);
		
		node *pop_node(node *);
		
		void add_semi_voronoi(node *, node *);

		int edges, blah;
		
		//first edge
		edge *edge_head;
		
		//last edge
		edge *edge_tail;
		
		int nodes;
		node *node_head;
		node *node_tail;
		
		void combine_vertices();
		int vertices;
		//point_list *vertice_head;
		//point_list *vertice1;
		point *vertice_head;
		point *vertice_tail;
		point *vertice1;
		
		//temporary edges, use anytime
		edge *edge1;
		edge *edge2;
		edge *edge3;
		node *node1;
		node *node2;
		node *new_node_tail;
		node *new_node_head;

		edge *newtail;
		edge *newhead;
		//edge *prev_edge2;
		
		Graph *GV;
		
		double worst_breach;

};

#endif
