#ifndef LINUX_COMPILE
#include "stdafx.h"
#endif

#include "map_init.h"
#include "map.h"
#include <fstream>
#include <iostream>
using namespace std;

//opens the specified file
//and adds the node positions
//and edges to the map
//returns 1 on success
//0 on failure
int create_map_from_file(ifstream *map_file, map *current_map) {
	double in;
	int nodes;
	double x, y, angle, sweep, range, max_range;
	int i;
	
	max_range = 0;
	
	//read width
	*map_file >> in;
	if(in <= 0 || map_file->eof()) return 0;
	current_map->set_width(in);
	
	//read height
	*map_file >> in;
	if(in <= 0 || map_file->eof()) return 0;
	current_map->set_height(in);
	
	//read number of nodes
	*map_file >> nodes;
	if(in <= 0 || map_file->eof()) return 0;
	
	current_map->simple_map = new (std::nothrow) basic_node[nodes];
	if(!current_map->simple_map) {
		cout << "Error, out of memory" << endl;
		exit(-1);
	}
	
	for(i=0; i<nodes; i++) {
		if(map_file->eof()) return 0;
		*map_file >> x;
		if(map_file->eof()) return 0;
		*map_file >> y;
		if(map_file->eof()) return 0;
		*map_file >> angle;
		if(map_file->eof()) return 0;
		*map_file >> sweep;
		if(map_file->eof()) return 0;
		*map_file >> range;
		current_map->add_node(x, y, angle, sweep, range);
		if(range > max_range) max_range = range;
		current_map->simple_map[i].x = x;
		current_map->simple_map[i].y = y;
		current_map->simple_map[i].initial_angle = angle;
		current_map->simple_map[i].sweep_angle = sweep;
		current_map->simple_map[i].range = range;
		current_map->simple_map[i].dest.x = x;
		current_map->simple_map[i].dest.y = y;
		current_map->simple_map[i].angle_dest = angle;
	}
	
	current_map->add_border();
	
	current_map->max_range = max_range;
	
	return 1;
}
