#ifndef LINUX_COMPILE
#include "stdafx.h"
#endif

#include <iostream>
using namespace std;

#include "node.h"
#include "edge.h"
#include "globals.h"
#include "math_functions.h"

#ifndef NULL
#define NULL 0
#endif

basic_node::~basic_node() {
}

node::~node() {
}

void node::delete_all() {
	if(next) {
		next->delete_all();
		//delete next;
	}
	delete this;
}

void basic_node::move(double dt, double width, double height, int movement_on, int rotation_on) {
			//handle position
	if(movement_on) {
		if(x == dest.x && y == dest.y) {
				//pick a new dest
			dest.x = drand48() * width;
			dest.y = drand48() * height;
			speed = drand48() * SPEED_CONST;
			speed += SPEED_MIN;
		} else {
			double x_ratio;
			double y_ratio;
			double d;
			d = speed * dt;
			d = d * d;
			if(y == dest.y) y_ratio = INF;
			else y_ratio = (x - dest.x)/(y - dest.y);
			y_ratio = y_ratio * y_ratio;
			if(x == dest.x) x_ratio = INF;
			else x_ratio = (y-dest.y)/(x-dest.x);
			x_ratio = x_ratio * x_ratio;
			
			if(x > dest.x) {
				//subtract from x
				x -= d / (1+x_ratio);
				if(x < dest.x) {
					x = dest.x;
				}
				
			} else {
				//add to x
				x += d / (1+x_ratio);
				if(x > dest.x) {
					x = dest.x;
				}
			}
			
			if(y > dest.y) {
				//subtract from y
				y -= d / (1+y_ratio);
				if(y < dest.y) {
					y = dest.y;
				}
				
			} else {
				//add to y
				y += d / (1+y_ratio);
				if(y > dest.y) {
					y = dest.y;
				}
			}
		}
	}
	
	if(rotation_on) {	
		//handle angle
		if(angle_dest == initial_angle) {
			angle_dest = drand48() * 360;
			angle_speed = (drand48() * ANGLE_SPEED_CONST);
			//angle_speed = 0;
			angle_speed += ANGLE_SPEED_MIN;
		} else {
				//check which direction to rotate
			if(angle_dest > initial_angle) {
				if(angle_dest - initial_angle < 180) {
					//add to initial angle
					//cout << dt << " " << angle_speed << " " << initial_angle << endl;
					initial_angle += (angle_speed*dt);
					//cout << initial_angle << endl;
					if(initial_angle > angle_dest) initial_angle = angle_dest;
				} else {
					//subtract from initial angle
					double temp;
					temp = angle_dest - 360;
					initial_angle -= (angle_speed*dt);
					if(initial_angle < temp) initial_angle = angle_dest;
					else while(initial_angle < 0) initial_angle += 360;
				}
			} else {
				if(initial_angle - angle_dest < 180) {
					//subtract from initial angle
					initial_angle -= (angle_speed*dt);
					if(initial_angle < angle_dest) initial_angle = angle_dest;
				} else {
					//add to initial angle
					double temp;
					temp = angle_dest + 360;
					initial_angle += (angle_speed*dt);
					if(initial_angle > temp) initial_angle = angle_dest;
					else while(initial_angle > 360) initial_angle -= 360;
				}
			}
				
		}
	}
	
	//cout << x << " " << y << " " << initial_angle << " " << sweep_angle << " " << range << endl;
}

//constructor:
//x,y, x,y, x,y
node::node(double x1, double y1, double x2, double y2, double x3, double y3) {
	prev = NULL;
	next = NULL;

	max_x = x1;
	min_x = x1;
	if(x2 > max_x) max_x = x2;
	if(x3 > max_x) max_x = x3;
	if(x2 < min_x) min_x = x2;
	if(x3 < min_x) min_x = x3;
	
	max_y = y1;
	min_y = y1;
	if(y2 > max_y) max_y = y2;
	if(y3 > max_y) max_y = y3;
	if(y2 < min_y) min_y = y2;
	if(y3 < min_y) min_y = y3;
	
	fov[0].x=x1;
	fov[0].y=y1;
	fov[1].x=x2;
	fov[1].y=y2;
	fov[2].x=x3;
	fov[2].y=y3;
	
	fov_e[0] = NULL;
	fov_e[1] = NULL;
	fov_e[2] = NULL;
}

//returns the intersection of the given fov edge
//null if it doesn't
//passed slope, x, y, edge num
point *node::intersect(double m, double x, double y, int index) {
	return fov_e[index]->intersect_line(m,x,y);
}

double node::get_x() {
	return fov[0].x;
}

double node::get_y() {
	return fov[0].y;
}

//returns true if the point falls inside of the field of view
//or on the edge of the field of view?
//false if it is outside
int node::inside(point *test_point) {
	return PointInTriangle(test_point, &fov[0], &fov[1], &fov[2]);
}

double node::get_max_x() {
	return max_x;
}

double node::get_min_x() {
	return min_x;
}

double node::get_max_y() {
	return max_y;
}

double node::get_min_y() {
	return min_y;
}

point *node::get_fov(int i) {
	return &fov[i];
}

edge *node::get_fov_e(int i) {
	return fov_e[i];
}

void node::set_fov_e(int i, edge *e) {
	fov_e[i] = e;
}

int node::overlaps(node *other) {
	//quick check first
	//quick check x
	if(other->get_max_x() < min_x) return 0;
	if(max_x < other->get_min_x()) return 0;
	if(other->get_max_y() < min_y) return 0;
	if(max_y < other->get_min_y()) return 0;

	//it may overlap
	//check if any segements intersect
	int i,j;
	for(i=0; i<3; i++) {
		for(j=0; j<3; j++) {
			if(fov_e[i]->intersects(other->get_fov_e(j))) {
				//the fovs overlap
				return 1;
			}
		}
	}
	
	//no overlap
	return 0;
}

