//Important note:
//By convention node is located at fov[0]

#ifndef NODE_H
#define NODE_H

#include "edge.h"

class basic_node {
	public:
		~basic_node();
		double x, y, initial_angle, sweep_angle, range;
		point dest;
		double speed;
		double angle_dest;
		double angle_speed;
		void move(double, double, double, int, int);
};

class node {
	public:
		//constructor:
		//x,y, x,y, x,y
		node(double, double, double, double, double, double);

		~node();
		
		double get_max_x();
		double get_min_x();
		double get_max_y();
		double get_min_y();
		
		int overlaps(node *);
		
		//returns true if the point falls inside of the field of view
		//or on the edge of the field of view
		//false if it is outside
		int inside(point *);
		
		//returns the intersection of the given fov edge
		//null if it doesn't
		//passed slope, x, y, edge num
		point *intersect(double, double, double, int);
		
		point *get_fov(int);
		edge *get_fov_e(int);
		void set_fov_e(int, edge *);
		
		void delete_all();
		
		double get_x();
		double get_y();
		
		node *prev;
		node *next;
		
	private:
		double max_x, min_x, max_y, min_y;
		point fov[3];
		edge *fov_e[3];
};

#endif
