//////////////////////////////////////////////////////////////////////
// DJ_GRAPH.H
//
// Seapahn Megerian (Meguerdichian)
// University of California at Los Angeles
// seapahn@cs.ucla.edu
//
// Djikstra Graph Algo
//////////////////////////////////////////////////////////////////////
#include "DJ_Graph.h"


/////////////////////
// DJ Graph Edge Stuff
//
DJ_Graph_Edge::DJ_Graph_Edge() {
}

DJ_Graph_Edge::~DJ_Graph_Edge() {
}


/////////////////////
// DJ Graph Node Stuff
//
DJ_Graph_Node::DJ_Graph_Node() {
	name  =0;
	weight=0;
	prev  =NULL;
	e_list.MakeEmpty();
}

DJ_Graph_Node::~DJ_Graph_Node() {
}

int DJ_Graph_Node::operator== (const DJ_Graph_Node &RHS) {	return (name ==RHS.name  ); }
int DJ_Graph_Node::operator<  (const DJ_Graph_Node &RHS) {	return (weight<RHS.weight); }
int DJ_Graph_Node::operator>  (const DJ_Graph_Node &RHS) {	return (weight>RHS.weight); }

const DJ_Graph_Node & DJ_Graph_Node::operator=(const DJ_Graph_Node &RHS) {
	name   = RHS.name;
	weight = RHS.weight;
	prev   = RHS.prev;
	e_list.MakeEmpty();		// FUTURE ADDON copy lists too
	return RHS;
}
	
void DJ_Graph_Node::init() {
	name  =0;
	weight=0;
	prev  =NULL;
	e_list.MakeEmpty();
}

int DJ_Graph_Node::add_edge(DJ_Graph_Node *dest, double weight) {
	DJ_Graph_Edge e;
	ListNode<DJ_Graph_Edge> *enp;
	enp=e_list.head->Next;
	while (enp && enp->Element.dest!=dest) enp=enp->Next;
	if (enp) {
		enp->Element.weight=weight;
		return 1;
	}
	
	e.dest=dest;
	e.weight=weight;
	return (e_list.Insert(e));
}


///////////////////
// DJ Graph Stuff
//
DJ_Graph::DJ_Graph() {
}

DJ_Graph::~DJ_Graph() {
}

int DJ_Graph::init() {
	nodes.MakeEmpty();
	return 1;
}

int DJ_Graph::add_edge(unsigned s, unsigned d, double weight) { // add bi edge from s to d
	DJ_Graph_Node t;
	DJ_Graph_Node *sn=NULL;
	DJ_Graph_Node *dn=NULL;

	t.name=s; if (nodes.Find(t)) sn=nodes.GetData();
	t.name=d; if (nodes.Find(t)) dn=nodes.GetData();

	if (!sn) {
		t.init();
		t.name=s;
		if (!nodes.Insert(t)) return 0;
		sn=&nodes.head->Next->Element;
	}

	if (!dn) {
		t.init();
		t.name=d;
		if (!nodes.Insert(t)) return 0;
		dn=&nodes.head->Next->Element;
	}

	if (!sn->add_edge(dn,weight)) return 0;
	if (!dn->add_edge(sn,weight)) return 0;
	return 1;
}


int DJ_Graph::do_Djikstra(unsigned s, unsigned d) {
	LinkedList<DJ_Graph_Node *> l;
	DJ_Graph_Edge *e;

	DJ_Graph_Node t;
	DJ_Graph_Node *sn=NULL;
	DJ_Graph_Node *dn=NULL;
	DJ_Graph_Node *curr, *temp;

	t.name=s; if (nodes.Find(t)) sn=nodes.GetData();
	t.name=d; if (nodes.Find(t)) dn=nodes.GetData();

	if (sn==NULL || dn==NULL) return 0; // start or destination do not exist

	sn->weight=0;
	sn->prev=sn;
	curr=sn;
	
	while (curr && curr->name!=d) {
		curr->e_list.Reset();
		while (curr->e_list.IsValid()) {
			e=curr->e_list.GetData();
			if (e->dest->prev==NULL)  {   // see if we must add to candidate list
				if (!l.Insert(e->dest)) return 0;
				e->dest->weight= curr->weight+e->weight;
				e->dest->prev  = curr;
			}
			else {
				if (curr->weight+e->weight < e->dest->weight) {
					e->dest->weight= curr->weight+e->weight;
					e->dest->prev  = curr;
				}
			}
			curr->e_list.Next();
		}

		l.Remove(curr);

		curr=NULL;
		l.Reset();
		if (l.IsValid()) {
			curr = *l.GetData();
			while (l.IsValid()) {
				temp = *l.GetData();
				if (temp->weight<curr->weight) curr=temp;
				l.Next();
			}
		}
	}
	if (curr==NULL) return 0;
	return 1;
}
