//////////////////////////////////////////////////////////////////////
// DJ_GRAPH.H
//
// Seapahn Megerian (Meguerdichian)
// University of California at Los Angeles
// seapahn@cs.ucla.edu
//
// Djikstra Graph Algo
//////////////////////////////////////////////////////////////////////

#ifndef SEAPAHN_DJ_GRAPH
#define SEAPAHN_DJ_GRAPH

class DJ_Graph_Node;
class DJ_Graph_Edge;

#include "linkedlist.h"

class DJ_Graph_Edge {
public:
	DJ_Graph_Node *dest;
	double weight;
	DJ_Graph_Edge();
	~DJ_Graph_Edge();
};

class DJ_Graph_Node {
public:
	unsigned name;
	double weight;
	LinkedList<DJ_Graph_Edge> e_list;
	DJ_Graph_Node *prev;

	void init();
	const DJ_Graph_Node & operator=(const DJ_Graph_Node &RHS);
	int operator==(const DJ_Graph_Node &RHS);
	int operator< (const DJ_Graph_Node &RHS);
	int operator> (const DJ_Graph_Node &RHS);
	int add_edge(DJ_Graph_Node *dest, double weight);

	DJ_Graph_Node();
	~DJ_Graph_Node();
};


class DJ_Graph  {
public:
	LinkedList<DJ_Graph_Node> nodes;
	
	int do_Djikstra(unsigned s, unsigned d);
	int add_edge(unsigned s, unsigned d, double weight);
	int init();
	DJ_Graph();
	~DJ_Graph();
};

#endif 


