// Exposure.h: interface for the Exposure class.
//
// Seapahn Megerian (Meguerdichian)
// University of California at Los Angeles
// seapahn@cs.ucla.edu
//
// Exposure calculation class definitions and related constants.
//////////////////////////////////////////////////////////////////////
#ifndef __EXPOSURE_H
#define __EXPOSURE_H


#include <stdlib.h>
#include <math.h>
#include <iostream.h>
#include "Sensor.h"	
#include "DJ_Graph.h"

// Sensor Layout (deployment scheme)
#define LAYOUT_RANDOM     0
#define LAYOUT_SQUARE     1 
#define LAYOUT_TRIANGLE   2
#define LAYOUT_HEXAGON    3
#define LAYOUT_KEEP_OLD   4
#define LAYOUT_PLUS       5
#define LAYOUT_INT_ERROR  6

#define MAX_SENSORS          1100
 
// Dimensions of the field
#define WIDTH 1000
#define HIGHT 1000

// Sensor models (1/d, 1/d^2, 1/d^3, 1/d^4, PAR: a/d^n using measured sensor parameters)
#define SENSOR_MODEL_D1         1
#define SENSOR_MODEL_D2         2
#define SENSOR_MODEL_D3         3
#define SENSOR_MODEL_D4         4
#define SENSOR_MODEL_PAR        4

// Intensity Models (closest sensor or all sensors)
#define INTENSITY_MODEL_CLOSEST 1
#define INTENSITY_MODEL_ALL     2

class Exposure {
public:
	void   init(unsigned ns, unsigned preset, unsigned s_model, unsigned i_model);
	void   set_grid(unsigned grid_count, unsigned grid_res);
	void   run_current_grid(unsigned start_row,unsigned start_col,unsigned dest_row,unsigned dest_col);
	void   run_side_to_side();
	void   Output();
	
	double sensor_strength(Sensor s, int x, int y);
	double intensity(int x, int y);
	double grid_line_exposure(unsigned s,unsigned d);
	
	unsigned NUM_SENSORS;
	Sensor   sensor[MAX_SENSORS];
	DJ_Graph G;
	
	unsigned g_res;
	unsigned g_div;
	unsigned intensity_model;
	unsigned sensor_model;
	unsigned data_valid;
	unsigned end_point_name;
	unsigned start_point_name;
	
	Exposure();
	~Exposure();
};

#endif 
