////////////////////////////////////////////////////
// Implementation of Linked LIST
//
// Seapahn Megerian (Meguerdichian)
// University of California at Los Angeles
// seapahn@cs.ucla.edu
//
////////////////////////////////////////////////////
#include "LinkedList.h"

///////////////////
// List Node Stuff
//
template <class T>
ListNode<T>::ListNode() { 
	Next = NULL;
} 


template <class T>
ListNode<T>::ListNode(const T &NodeElement, ListNode *NodeNext) {
	Element = NodeElement;
	Next = NodeNext;
} 


template <class T>
ListNode<T>::~ListNode() {
}


/////////////////////
// Linked List Stuff
//
template <class T>
LinkedList<T>::LinkedList() {
	head = new ListNode<T>;
	curr = head;
	Number = 0;
} 


template <class T>
LinkedList<T>::LinkedList(LinkedList<T> &RHS) {
	head = new ListNode<T>;
	curr= head;
	Number = 0;
	*this = RHS;
} 


template <class T>
LinkedList<T>::~LinkedList() {
	MakeEmpty();
	delete head;
}



template <class T>
int LinkedList<T>::Size(void) {
	return (Number);
}



template <class T>
int LinkedList<T>::IsEmpty(void) {
	if (Number <= 0) return 1;
	return (0);
}



template <class T>
void LinkedList<T>::MakeEmpty(void) {
	ListNode<T> *NextNode; // Pointer to the Next Node

	curr= head->Next;
	while (curr!=NULL) {
		NextNode = curr->Next;
		delete curr;
		curr= NextNode;
	}
	head->Next = NULL;
	curr= head;
	Number = 0;
}



template <class T>
void LinkedList<T>::Reset(void) {
	if (head->Next != NULL)
		curr= head->Next;
	else
		curr= head;
}


template <class T>
void LinkedList<T>::Next() {
	if (curr!=NULL)	curr=curr->Next;
}



template <class T>
int LinkedList<T>::IsValid(void) { 
	if (curr== NULL || curr==head) return (0);
	return 1;
} 



template <class T>
int LinkedList<T>::Insert(const T &NewElement) {
	ListNode<T> *NewNode = NULL; // Pointer to New Node

	if (head==NULL) return 0;
	NewNode = new ListNode<T>(NewElement, head->Next);
	if (NewNode==NULL) return 0;
    head->Next = NewNode;
    Number++;
    return 1;
}



template <class T>
int LinkedList<T>::Remove(const T &e) {
	ListNode<T> *TempNode=NULL;
	
	curr = head;
	while (curr && curr->Next) {
		if (curr->Next->Element == e) {
			TempNode = curr->Next->Next;
			delete curr->Next;
			curr->Next = TempNode;
			Number--;
			return 1;
		}
		curr = curr->Next;
	}
	return 0;
}



template <class T>
int LinkedList<T>::Find(const T &e) {
	int Success = 0;

	curr = head;
	while (curr->Next && !Success) {
		if (curr->Next->Element == e) Success = 1;
		curr = curr->Next;
	}
	return (Success);
} 


template <class T>
T* LinkedList<T>::GetData(void) {
	return (&(curr->Element));
} 



// FUTURE ADDON
/*template <class T>
LinkedList<T>& LinkedList<T>::operator = (LinkedList<T> &RHS) {
	ListNode<T> *RHSPtr = NULL; // Current Pointer to RHS Node
	if (this == &RHS) return (*this);
	MakeEmpty();
	if (!RHS.IsEmpty())  {
		RHSPtr = RHS.head->Next;
		while (RHSPtr != NULL) {
			Insert(RHSPtr->Element);
			RHSPtr = RHSPtr->Next;
			curr= curr->Next;
		}
	}
	return (*this);
}*/