//////////////////////////////////////////////////////////////
// Generic Linked LIST
//
// Seapahn Megerian (Meguerdichian)
// University of California at Los Angeles
// seapahn@cs.ucla.edu
//
// Insert():     Inserts an Item to the List in front of the current
// Remove():     Removes the Current Item from the List
// Find():       Finds an Item in the List and puts the Current Pointer there
// IsValid():    Returns if the Current Pointer is Still Valid
// IsFull():     Returns if the list is full
// Size():       Returns the Size of the List
// MakeEmpty():  Empties the Linked List
// Reset():      Puts the Current Pointer at the Beginning
// Advance():    Goes to the Next Element
// Step():       Goes to the Next Element But Remembers the Last
// BackStep():   Goes to the Previous Element
// GetData():    Returns a Pointer to the Current Data


#ifndef SEAPAHN_LIST
#define SEAPAHN_LIST

#include <iostream.h>


template <class T>
class ListNode {
  public:
    ListNode();
    ListNode(const T &NodeElement, ListNode *NodeNext = NULL);
    ~ListNode();

    T Element;          
    ListNode<T> *Next;  
}; 


template <class T>
class LinkedList {
  public:
    LinkedList();
    LinkedList(LinkedList<T> &RHS);
    ~LinkedList();

    int   Insert(const T &e);          // Inserts an Element
    int   Remove(const T &e);          // Removes an Element
    int   Find  (const T &e);          // Sets Position if Found
    int   IsEmpty();                   // Returns if the List Empty
    int   IsValid();                   // Makes Sure List Can Advance
    int   Size();                      // Returns Current Size 
    void  MakeEmpty();                 // Makes the List Empty
    void  Reset();                     // Returns to the Start
    void  Next ();                     // Advances to the Next
    void  Prev ();                     // Goes Back to Last Element
    T* GetData();                      // Returns Pointer to Data

    // LinkedList<T>& operator = (LinkedList<T> &RHS); // FUTURE ADDON

    int Number;                        // Number of Elements
    ListNode<T> *head;                 // First Node in the List
    ListNode<T> *curr;                 // Current Node Being Looked At
};


#include "linkedlist.cpp"
#endif
